package test.org.seasar.nazuna;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.RuletCompiler;

public class RuletCompilerTest extends TestCase {

    public RuletCompilerTest(String name) {
        super(name);
    }

    public void testCompile() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	File srcFile = RuletCompiler.getSrcFile(className);
    	File classFile = RuletCompiler.getClassFile(className);
    	classFile.delete();
    	RuletCompiler.compile(srcFile, classFile);
    	assertEquals("1", true, classFile.exists());
    	assertEquals("2", srcFile.lastModified(), classFile.lastModified());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(RuletCompilerTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{RuletCompilerTest.class.getName()});
    }
}