package test.org.seasar.nazuna;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.MapResultType;
import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.Sqlet;
import org.seasar.util.SMap;
import org.seasar.util.SeasarContext;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class ResultTypeTest2 extends ConnectionPoolTestCase {

	public ResultTypeTest2(String name) {
		super(name);
	}

	public void testCreate() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		try {
			con = ctx.getConnection();
			stmt = con.createStatement();
			rs = stmt.executeQuery("select * from emp where empno = 0");
			ResultType rt = MapResultType.create(rs.getMetaData());
			assertEquals("1", SMap.class, rt.getResultClass());
			assertEquals("2", 9, rt.getPropertyTypeSize());
		} finally {
			Sqlet.close(rs, stmt, con);
		}
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static Test suite() {
		return new TestSuite(ResultTypeTest2.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ResultTypeTest2.class.getName()});
	}
}