package test.org.seasar.nazuna;

import org.seasar.nazuna.NazunaService;
import org.seasar.nazuna.NazunaURL;
import org.seasar.nazuna.RemoteLocation;
import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.RMIAdaptorService;
import org.seasar.util.ArrayUtil;

import junit.framework.TestCase;

public class RemoteLocationTest2 extends TestCase {

	private static final String HELLO_RULET =
		"test.org.seasar.nazuna.HelloRulet";

	public RemoteLocationTest2(String arg0) {
		super(arg0);
	}

	public void testRoundRobin() throws Exception {
		RMIAdaptorService rmiAdaptorService = new RMIAdaptorService();
		RMIAdaptorService rmiAdaptorService2 = new RMIAdaptorService();
		rmiAdaptorService.start();
		rmiAdaptorService2.start();

		NazunaService nazunaService = new NazunaService();
		JMXService.registerMBean(nazunaService, JMXUtil.getMBeanName("nazuna"));

		try {
			NazunaURL url =
				new NazunaURL("rmi://localhost:" + rmiAdaptorService.getPort());
			NazunaURL url2 =
				new NazunaURL(
					"rmi://localhost:" + rmiAdaptorService2.getPort());
			RemoteLocation remoteLoc = new RemoteLocation("remote");
			remoteLoc.addURL(url);
			remoteLoc.addURL(url2);

			for (int i = 0; i < 5; ++i) {
				remoteLoc.executeRulet(HELLO_RULET, ArrayUtil.EMPTY_OBJECTS);
			}
		} finally {
			JMXService.unregisterMBean(JMXUtil.getMBeanName("nazuna"));
			rmiAdaptorService.stop();
			rmiAdaptorService2.stop();
		}
	}

	public void testFailover() throws Exception {
		RMIAdaptorService rmiAdaptorService = new RMIAdaptorService();
		rmiAdaptorService.start();

		NazunaService nazunaService = new NazunaService();
		JMXService.registerMBean(nazunaService, JMXUtil.getMBeanName("nazuna"));

		try {
			NazunaURL url =
				new NazunaURL("rmi://localhost:" + rmiAdaptorService.getPort());
			NazunaURL url2 = new NazunaURL("rmi://hoge:1108");
			RemoteLocation remoteLoc = new RemoteLocation("remote");
			remoteLoc.addURL(url);
			remoteLoc.addURL(url2);

			for (int i = 0; i < 5; ++i) {
				remoteLoc.executeRulet(HELLO_RULET, ArrayUtil.EMPTY_OBJECTS);
			}
		} finally {
			JMXService.unregisterMBean(JMXUtil.getMBeanName("nazuna"));
			rmiAdaptorService.stop();
		}
	}

	public void testFailover2() throws Exception {
		RMIAdaptorService rmiAdaptorService = new RMIAdaptorService();
		rmiAdaptorService.start();

		NazunaService nazunaService = new NazunaService();
		JMXService.registerMBean(nazunaService, JMXUtil.getMBeanName("nazuna"));

		try {
			NazunaURL url =
				new NazunaURL("rmi://localhost:" + rmiAdaptorService.getPort());
			NazunaURL url2 = new NazunaURL("rmi://localhost:1");
			RemoteLocation remoteLoc = new RemoteLocation("remote");
			remoteLoc.addURL(url);
			remoteLoc.addURL(url2);

			for (int i = 0; i < 5; ++i) {
				remoteLoc.executeRulet(HELLO_RULET, ArrayUtil.EMPTY_OBJECTS);
			}
		} finally {
			JMXService.unregisterMBean(JMXUtil.getMBeanName("nazuna"));
			rmiAdaptorService.stop();
		}
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(RemoteLocationTest2.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

}
