package test.org.seasar.nazuna;

import org.seasar.nazuna.NazunaURL;
import org.seasar.nazuna.RemoteLocation;
import org.seasar.util.ArrayUtil;

public class RemoteLocationTest extends NazunaServiceTestCase {

	private static final String HELLO_RULET =
		"test.org.seasar.nazuna.HelloRulet";
		
	public RemoteLocationTest(String name) {
		super(name);
	}

	public void testExecuteRulet() throws Exception {
		String spec = "rmi://localhost:" + _rmiAdaptorService.getPort();
		NazunaURL url = new NazunaURL(spec);
		RemoteLocation remoteLoc = new RemoteLocation("remote");
		remoteLoc.addURL(url);
		assertEquals(
			"1",
			"hello",
			remoteLoc.executeRulet(HELLO_RULET, ArrayUtil.EMPTY_OBJECTS));
		assertEquals(
			"2",
			"hello",
			remoteLoc.executeRulet(HELLO_RULET, ArrayUtil.EMPTY_OBJECTS));
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}