package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.PropertyType;
import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.ResultTypeBuilder;
import org.seasar.nazuna.ValueType;

public class PropertyTypeTest extends TestCase {

    public PropertyTypeTest(String name) {
        super(name);
    }
    
    public void testValueType() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Employee.xml";
    	ResultType resultType = ResultTypeBuilder.parse(xmlFileName);
    	PropertyType propertyType = resultType.getPropertyType(0);
    	assertEquals("1", ValueType.INTEGER, propertyType.getValueType());
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(PropertyTypeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{PropertyTypeTest.class.getName()});
    }
}