package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.NewArrayExp;
import org.seasar.nazuna.StringExp;

public class NewArrayExpTest extends TestCase {

    public NewArrayExpTest(String name) {
        super(name);
    }
    
    public void testEvaluateValue() throws Exception {
    	Expression exp = new NewArrayExp(String.class, 2, Expression.EMPTY_EXPRESSIONS);
    	String[] ret = (String[]) exp.evaluateValue(null);
        assertEquals("1", 2, ret.length);
    }
    
    public void testEvaluateValue2() throws Exception {
    	List argExpList = new ArrayList();
    	argExpList.add(new StringExp("aaa"));
    	argExpList.add(new StringExp("bbb"));
    	Expression exp = new NewArrayExp(String.class, 2,
    		NazunaUtil.toExpressionArray(argExpList));
    	String[] ret = (String[]) exp.evaluateValue(null);
        assertEquals("1", 2, ret.length);
        assertEquals("2", "aaa", ret[0]);
        assertEquals("3", "bbb", ret[1]);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(NewArrayExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NewArrayExpTest.class.getName()});
    }
}