package test.org.seasar.nazuna;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.GetVariableExp;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleContextImpl;
import org.seasar.util.EMap;

public class GetVariableExpTest extends TestCase {

    public GetVariableExpTest(String name) {
        super(name);
    }

    public void testEvaluateValue() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("mybean", MyBean.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	MyBean myBean = new MyBean();
    	Map parameters = new EMap();
    	parameters.put("mybean", myBean);
        GetVariableExp varExp = new GetVariableExp("mybean.aaa");
        RuleContext ruleContext = new RuleContextImpl(rule, parameters);
        assertEquals("1", "test", varExp.evaluateValue(ruleContext));
    }
    
    public void testEvaluateValue2() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("map", Map.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	Map parameters = new EMap();
    	Map map = new EMap();
    	map.put("aaa", "test");
    	parameters.put("map", map);
        GetVariableExp varExp = new GetVariableExp("map.aaa");
        assertEquals("1", "test", varExp.evaluateValue(new RuleContextImpl(rule, parameters)));
    }
    
    public void testEvaluateValue3() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("map2", Map.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	Map parameters = new EMap();
    	Map map = new EMap();
    	map.put("aaa", "test");
    	Map map2 = new EMap();
    	map2.put("map", map);
    	parameters.put("map2", map2);
        GetVariableExp varExp = new GetVariableExp("map2.map.aaa");
        assertEquals("1", "test", varExp.evaluateValue(new RuleContextImpl(rule, parameters)));
    }
    
    public void testEvaluateValue4() throws Exception {
    	Flowlet rule = new Flowlet();
    	rule.addConst("HELLO", "Hello");
        GetVariableExp varExp = new GetVariableExp("HELLO");
        RuleContext ruleContext = new RuleContextImpl(rule, null);
        assertEquals("1", "Hello", varExp.evaluateValue(ruleContext));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(GetVariableExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{GetVariableExpTest.class.getName()});
    }
    
    public static class MyBean {
    	
    	private String _aaa = "test";
    	
    	public String getAaa() {
    		return _aaa;
    	}
    }
}