package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.CoalesceExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.StringExp;

public class CoalesceExpTest extends TestCase {

    public CoalesceExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        List expList = new ArrayList();
		expList.add(new NullExp());
        expList.add(new StringExp("111"));
        Expression exp = new CoalesceExp(NazunaUtil.toExpressionArray(expList));
        assertEquals("1", "111", exp.evaluateValue(null));
    }
    
    public void testEvaluate2() throws Exception {
        List expList = new ArrayList();
		expList.add(new StringExp("222"));
        expList.add(new StringExp("111"));
        Expression exp = new CoalesceExp(NazunaUtil.toExpressionArray(expList));
        assertEquals("1", "222", exp.evaluateValue(null));
    }
    
    public void testEvaluate3() throws Exception {
        List expList = new ArrayList();
		expList.add(new NullExp());
        expList.add(new NullExp());
        Expression exp = new CoalesceExp(NazunaUtil.toExpressionArray(expList));
        assertEquals("1", null, exp.evaluateValue(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(CoalesceExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{CoalesceExpTest.class.getName()});
    }
}