package org.seasar.sql;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public final class DataSourceImpl implements DataSource, Referenceable, Serializable {

    static final long serialVersionUID = -4800810591676756116L;
    private String _dataSourceName;

    public DataSourceImpl() {
    }

    public String getDataSourceName() {
        return _dataSourceName;
    }

    public void setDataSourceName(final String dataSourceName) {
        _dataSourceName = dataSourceName;
    }

    public Connection getConnection() throws SQLException {
        return ConnectionPoolManager.getInstance().getConnectionPool(
                _dataSourceName).requestXAConnection().getConnection();
    }

    public Connection getConnection(final String user, final String password)
	throws SQLException {

        return getConnection();
    }

    public void setLoginTimeout(final int loginTimeout) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLogWriter(final PrintWriter logWriter) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(getClass().getName(),
                DataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("dataSourceName", getDataSourceName()));
        return ref;
    }
}