package org.seasar.nazuna;

public abstract class SortType {

	public final static SortType ASC = new Asc();
	public final static SortType DESC = new Desc();

	private SortType() {
	}

	abstract int compare(Object o1, Object o2);

	private static class Asc extends SortType {

		int compare(Object o1, Object o2) {
			Comparable c1 = (Comparable)o1;
			Comparable c2 = (Comparable)o2;
			if (c1 != null && c2 != null) {
				return c1.compareTo(c2);
			} else if (c1 == null && c2 == null) {
				return 0;
			} else if (c1 == null) {
				return 1;
			} else {
				return -1;
			}
		}
	}

	private static class Desc extends SortType {

		int compare(Object o1, Object o2) {
			Comparable c1 = (Comparable)o1;
			Comparable c2 = (Comparable)o2;
			if (c1 != null && c2 != null) {
				return c2.compareTo(c1);
			} else if (c1 == null && c2 == null) {
				return 0;
			} else if (c2 == null) {
				return 1;
			} else {
				return -1;
			}
		}
	}
}