package org.seasar.nazuna;

public abstract class GroupType {

    public static final GroupType SUM = new SumType();
    public static final GroupType MAX = new MaxType();
    public static final GroupType MIN = new MinType();
    public static final GroupType COUNT = new CountType();
    public static final GroupType AVG = new AvgType();

    private GroupType() {
    }

    public abstract GroupValue newGroupValue(GroupElement groupElement);

    private static class SumType extends GroupType {

        public GroupValue newGroupValue(final GroupElement groupElement) {
            return new GroupValue.SumValue(groupElement);
        }
    }

    private static class MaxType extends GroupType {

        public GroupValue newGroupValue(final GroupElement groupElement) {
            return new GroupValue.MaxValue(groupElement);
        }
    }

    private static class MinType extends GroupType {

        public GroupValue newGroupValue(final GroupElement groupElement) {
            return new GroupValue.MinValue(groupElement);
        }
    }

    private static class CountType extends GroupType {

        public GroupValue newGroupValue(final GroupElement groupElement) {
            return new GroupValue.CountValue(groupElement);
        }
    }

    private static class AvgType extends GroupType {

        public GroupValue newGroupValue(final GroupElement groupElement) {
            return new GroupValue.AvgValue(groupElement);
        }
    }
}