package org.seasar.nazuna;

import org.seasar.util.SeasarException;

public final class AssertTag extends ThrowTag {

	private BooleanExpression _conditionExp;
	
	public AssertTag(Object parent, String location,
			BooleanExpression conditionExp) {
				
		super(parent, location);
		_conditionExp = conditionExp;
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			if (!_conditionExp.evaluate(ruleContext)) {
				executeReal(ruleContext);
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}
}
