package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.EMap;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public abstract class AbstractExecuteExp implements Expression {

    private final Expression _pathExp;
    private final EMap _parameterExps;

    public AbstractExecuteExp(final Expression pathExp, EMap parameterExps) {
    	Assertion.assertNotNull("pathExp", pathExp);
    	Assertion.assertNotNull("parameterExps", parameterExps);
    	
        _pathExp = pathExp;
        _parameterExps = parameterExps;
    }

    public Object evaluateValue(final RuleContext ruleContext)
    		throws SeasarException {
    			
    	Map parameters = new SMap();
    	for (int i = 0; i < _parameterExps.size(); ++i) {
    		Expression exp = (Expression) _parameterExps.get(i);
    		Object value = exp.evaluateValue(ruleContext);
    		parameters.put(_parameterExps.getKey(i), value);
    	}
    	String path = (String) _pathExp.evaluateValue(ruleContext);
    	return doExecute(path, parameters);
    }
    
    protected abstract Object doExecute(String path, Map parameters)
    		throws SeasarException;
}
