package org.seasar.jetty;

import org.seasar.log.Logger;
import org.seasar.system.Lifecycle;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.ThrowableUtil;


public final class JettyService implements Lifecycle {
	
	private String _configPath = "jetty.xml";
	private Jetty _jetty;

	public JettyService() {
	}
	
	public final String getConfigPath() {
		return _configPath;
	}
	
	public final void setConfigPath(String configPath) {
		_configPath = configPath;
	}

	public final void start() throws SeasarException {
		try {
			_jetty = new Jetty(ResourceUtil.getResource(_configPath));
			_jetty.start();
		} catch (Exception ex) {
			_jetty = null;
			Throwable t = ThrowableUtil.getCause(ex);
			throw SeasarException.convertSeasarException(t);
		}
	}

	public final void stop() {
		if (_jetty == null) {
			return;
		}
		try {
			_jetty.stop();
		} catch (InterruptedException e) {
			Logger.getLogger(getClass()).log(e);
		}
		_jetty = null;
	}

	public final boolean isStarted() {
		return _jetty != null;
	}
	
	public final boolean isStopped() {
		return _jetty == null;
	}
}
