package org.seasar.eclipse.properties;

import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.seasar.eclipse.SeasarPlugin;
import org.seasar.eclipse.SeasarProject;

public class SeasarProjectPropertyPage extends PropertyPage 
        implements IWorkbenchPreferencePage {

    private static final int TEXT_FIELD_WIDTH = 200;
    private Button _seasarProjectCheck;
    private Text _contextPathText;
    
    public SeasarProjectPropertyPage() {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);    
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        createSeasarProjectGroup(composite);
        createContextPathGroup(composite);
        return composite;
    }

    private void createSeasarProjectGroup(Composite parent) {
        Composite seasarProjectGroup = new Composite(parent,SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        seasarProjectGroup.setLayout(layout);
        seasarProjectGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        _seasarProjectCheck = new Button(seasarProjectGroup, SWT.CHECK | SWT.LEFT);
        _seasarProjectCheck.setText(SeasarPlugin.getResourceString("isSeasarProject.label"));
        _seasarProjectCheck.setEnabled(true);
        try {       
            _seasarProjectCheck.setSelection(getProject().hasNature(SeasarProject.NATURE_ID));
        } catch (CoreException ex) {
            SeasarPlugin.handleException(ex);  
        }
    }

    private void createContextPathGroup(Composite parent) {
        Composite contextPathGroup = new Composite(parent,SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        contextPathGroup.setLayout(layout);
        contextPathGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        Label contextPathLabel = new Label(contextPathGroup,SWT.NONE);
        contextPathLabel.setText(SeasarPlugin.getResourceString("contextPath.label"));
        contextPathLabel.setEnabled(true);
        _contextPathText = new Text(contextPathGroup, SWT.BORDER);
        GridData data = new GridData(GridData.FILL_HORIZONTAL);
        data.widthHint = TEXT_FIELD_WIDTH;
        _contextPathText.setLayoutData(data);        
        _contextPathText.setText(getContextPath()); 
        _contextPathText.setEnabled(true);
    }
            
    protected String getContextPath() {
        try {
            SeasarProject seasarProject = getSeasarProject();
            if (seasarProject != null) {
                return seasarProject.getContextPath();
            } else {
                return "/" + getProject().getName();
            }
        } catch (CoreException ignore) {
            return "/hoge";
        }
    }

    public boolean performOk() {
        try {
            if (isSeasarProjectChecked()) {
                IJavaProject javaProject = getJavaProject();    
                SeasarProject.addSeasarNature(javaProject);
                SeasarProject seasarProject = getSeasarProject();
                seasarProject.setContextPath(_contextPathText.getText());
                seasarProject.storeProperties();
                seasarProject.updateWebApplicationInJettyXML();
            } else {
                SeasarProject seasarProject = getSeasarProject();
                if (seasarProject != null) {
                    seasarProject.removeWebApplicationInJettyXML();
                    seasarProject.removeSeasarNature();
                }
            }
        } catch (CoreException ex) {
            SeasarPlugin.handleException(ex);  
        } catch (IOException ex) {
            SeasarPlugin.handleException(ex);  
        }
        return true;
    }
    
    public boolean isSeasarProjectChecked() {
        return _seasarProjectCheck.getSelection();
    }
    
    public void init(IWorkbench workbench) {
    }

    private IProject getProject() throws CoreException {
        return (IProject) getElement().getAdapter(IProject.class);
    }
    
    private IJavaProject getJavaProject() throws CoreException {
        IProject project = getProject();
        return (IJavaProject) project.getNature(JavaCore.NATURE_ID);
    }
    
    private SeasarProject getSeasarProject() throws CoreException {
        return SeasarProject.getSeasarProject(getJavaProject());
    }
}