/*
class test.seasar.unit.AssertTest extends seasar.unit.TestCase
*/
if (test.seasar.unit.AssertTest == null) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/TestCase.as"
	#include "seasar/unit/TestResult.as"
	#include "seasar/unit/Assert.as"
	
	seasar.lang.SObject.defineClass("test.seasar.unit.AssertTest", seasar.unit.TestCase, ["result", "assert"]);
		
	var proto = test.seasar.unit.AssertTest.prototype;
	
	proto.setUp = function() {
		this.result = new seasar.unit.TestResult();
		this.assert = new seasar.unit.Assert();
		this.assert.prepare(this.result, "testHoge");
		this.oldHoge = _global.hoge;
		delete _global.hoge;
	}
	
	proto.tearDown = function() {
		_global.hoge = this.oldHoge;
		this.result = null;
		this.assert = null;
	}
	
	proto.testAssertTrue = function() {
		this.assertEquals(0, this.assert.seq);
		this.assert.assertTrue(true);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertTrue(false);
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected true", failure.message);
	}
	
	proto.testAssertTrue2 = function() {
		this.assert.assertTrue("aaa", false);
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected true", failure.message);
	}
	
	proto.testAssertNull = function() {
		this.assert.assertNull(null);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertNull("hoge");
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected null", failure.message);
	}
	
	proto.testAssertNull2 = function() {
		this.assert.assertNull("aaa", "hoge");
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected null", failure.message);
	}
	
	proto.testAssertNotNull = function() {
		this.assert.assertNotNull("hoge");
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertNotNull(null);
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected not null", failure.message);
	}
	
	proto.testAssertNotNull2 = function() {
		this.assert.assertNotNull("aaa", null);
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected not null", failure.message);
	}
	
	proto.testAssertDefined = function() {
		this.assert.assertDefined(this);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertDefined(_global.hoge);
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected defined", failure.message);
	}
	
	proto.testAssertDefined2 = function() {
		this.assert.assertDefined("aaa", _global.hoge);
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected defined", failure.message);
	}
	
	proto.testAssertUnefined = function() {
		this.assert.assertUndefined(_global.hoge);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertUndefined(this);
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected undefined", failure.message);
	}
	
	proto.testAssertUndefined2 = function() {
		this.assert.assertUndefined("aaa", this);
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected undefined", failure.message);
	}
	
	proto.testAssertEquals = function() {
		this.assert.assertEquals(1, 1);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(1, this.assert.seq);
		
		this.assert.assertEquals(1, 2);
		this.assertEquals(2, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
		this.assertEquals(2, this.assert.seq);
		var failure = this.result.getFailure(0);
		this.assertEquals("seasar.unit.Assert", failure.className);
		this.assertEquals("testHoge", failure.methodName);
		this.assertEquals("2 expected:<1> but was:<2>", failure.message);
	}
	
	proto.testAssertEquals2 = function() {
		this.assert.assertEquals("aaa", 1, 2);
		var failure = this.result.getFailure(0);
		this.assertEquals("aaa expected:<1> but was:<2>", failure.message);
	}

	delete proto;
}