package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class RegExpTest extends TestCase {

    public RegExpTest(String name) {
        super(name);
    }

    public void testMatch() throws Exception {
        assertEquals("1", true, RegExp.match("[a-zA-Z]*", "abcAbe"));
        assertEquals("2", false, RegExp.match("[a-zA-Z]*", "abcAbe1"));
        assertEquals("3", false, RegExp.match("[a-zA-Z]*", null));
    }
    
    public void testMatchIgnoreCase() throws Exception {
        assertEquals("1", true, RegExp.matchIgnoreCase("[a-z]*", "abcABC"));
    }

    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(RegExpTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{RegExpTest.class.getName()});
    }
}
