package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class ArrayUtilTest extends TestCase {

    public ArrayUtilTest(String name) {
        super(name);
    }

    public void testAdd() throws Exception {
        String[] a = new String[]{"1", "2"};
        String[] b = new String[]{"3"};
        a = (String[]) ArrayUtil.add(a, b);
        assertEquals("1", 3, a.length);
        assertEquals("2", "1", a[0]);
        assertEquals("3", "2", a[1]);
        assertEquals("4", "3", a[2]);
    }

    public void testClone() throws Exception {
        String[] a = new String[]{"1", "2"};
        String[] b = (String[]) ArrayUtil.clone(a);
        assertEquals("1", a.length, b.length);
        assertEquals("2", "1", b[0]);
        assertEquals("3", "2", b[1]);
    }

    public void testEquals() throws Exception {
        String[] a = new String[]{"1", "2"};
        String[] b = new String[]{"1", "1"};
        String[] c = new String[]{"1", "2", "3"};
        String[] d = new String[]{"1", null};
        assertTrue("1", ArrayUtil.equals(a, a));
        assertTrue("2", ArrayUtil.equals(null, null));
        assertTrue("3", ArrayUtil.equals(d, d));
        assertTrue("4", !ArrayUtil.equals(a, b));
        assertTrue("5", !ArrayUtil.equals(a, c));
        assertTrue("6", !ArrayUtil.equals(a, d));
    }


    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(ArrayUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ArrayUtilTest.class.getName()});
    }
}
