package test.org.seasar.system;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.RMINotificationListenerAdaptor;
import org.seasar.util.SeasarContext;

public class RMINotificationListenerAdaptorTest extends RMIAdaptorTestCase {

  	public RMINotificationListenerAdaptorTest(String name) {
    	super(name);
  	}

  	public void testNotify() throws Throwable {
    	Notify notify = new Notify();
    	JMXService.registerMBean(notify, NotifyMBean.NAME);
    	
    	NotificationListenerTester listenerTester = new NotificationListenerTester();
    	RMINotificationListenerAdaptor rmiListenerAdaptor =
    		new RMINotificationListenerAdaptor(NotifyMBean.NAME, listenerTester,
    		SeasarContext.getInstance());
    	rmiListenerAdaptor.addNotificationListener();
    	try {
    		notify.sendMessage("Hello");
    		assertEquals("1", true, listenerTester.isCalled());
    	} finally {
    		rmiListenerAdaptor.removeNotificationListener();
    	}
  	}
  	

  	protected void setUp() throws Exception {
  		super.setUp();
  	}

  	protected void tearDown() throws Exception {
  		super.tearDown();
  	}

  	public static Test suite ( ) {
    	return new TestSuite(RMINotificationListenerAdaptorTest.class);
  	}

  	public static void main (String[] args) {
    	junit.textui.TestRunner.main(new String[]{RMINotificationListenerAdaptorTest.class.getName()});
  	}
}