package test.org.seasar.system;

import java.lang.reflect.Method;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.MBeanMetaData;
import org.seasar.system.MBeanProxy;
import org.seasar.util.EMap;
import org.seasar.util.Reflector;

public class MBeanMetaDataTest extends RMIAdaptorTestCase {

	private static final String[] SIGS = new String[]{"int", "boolean", "java.util.Map"};
	private static final Class[] PARA_TYPES = new Class[]{int.class, boolean.class, Map.class};
	private static final Object[] ARGS = new Object[]{new Integer(1), Boolean.TRUE, new EMap()};
	private static Map _primitiveTypes = new EMap();
	
	static {
		_primitiveTypes.put("int", int.class);
		_primitiveTypes.put("boolean", boolean.class);
	}
	
    public MBeanMetaDataTest(String name) {
        super(name);
    }

    public void testGetSignature() throws Exception {
    	Method m = Reflector.getMethod(HelloMBean.class, "foo", PARA_TYPES);
    	String sig = MBeanMetaData.getMethodSignature(m);
    	assertEquals("1", "foo(int;boolean;java.util.Map;)", sig);
    	
    	String[] sigs = new String[]{"int", "boolean", "java.util.Map"};
    	String sig2 = MBeanMetaData.getMethodSignature("foo", SIGS);
    	assertEquals("2", "foo(int;boolean;java.util.Map;)", sig2);
    	
    	m.invoke(new Hello(), ARGS);
    }
    
    public void testGetMethod() throws Exception {
    	MBeanMetaData metaData = MBeanMetaData.getInstance(Hello.class);
    	Method m = metaData.getMethod("greeting", null);
    	assertNotNull("1", m);
    	assertEquals("2", "hello", m.invoke(new Hello(), null));
    }
    
    public void testProxy() throws Exception {
    	Hello hello = new Hello();
    	JMXService.registerMBean(hello, Hello.NAME);
    	HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, Hello.NAME);
    	NotifyMBean proxy2 = (NotifyMBean) MBeanProxy.create(NotifyMBean.class, Notify.NAME);
    	System.out.println("proxy.getClass().equals(proxy2.getClass()):" +
    		proxy.getClass().equals(proxy2.getClass()));
    	System.out.println(proxy.getClass().hashCode() + "," + proxy2.getClass().hashCode());
    	Class[] interfaces = proxy.getClass().getInterfaces();
    	for (int i = 0; i < interfaces.length; i++) {
    		System.out.println(interfaces[i]);
    	}
    	MBeanMetaData metaData = MBeanMetaData.getInstance(proxy.getClass());
    	Method m = metaData.getMethod("greeting", null);
    	assertNotNull("1", m);
    	assertEquals("2", "hello", m.invoke(proxy, null));
    }
    
    public void testSpike() throws Exception {
    	Hello hello = new Hello();
    	Method m = Reflector.getMethod(HelloMBean.class, "foo2", PARA_TYPES);
    	Map map = new EMap();
    	map.put(MBeanMetaData.getMethodSignature(m), m);
		
		int num = 100000;
		long start = System.currentTimeMillis();
		for (int i = 0; i < num; i++) {
			Class[] paraTypes = new Class[SIGS.length];
			for (int j = 0; j < SIGS.length; j++) {
				Class clazz = (Class) _primitiveTypes.get(SIGS[j]);
				if (clazz != null) {
					paraTypes[j] = clazz;
				} else {
					ClassLoader cl = Thread.currentThread().getContextClassLoader();
					paraTypes[j] = cl.loadClass(SIGS[j]);
				}
			}
			Method m2 = Reflector.getMethod(hello.getClass(), "foo2", paraTypes);
			m2.invoke(hello, ARGS);
		}
		System.out.println("reflection:" + (System.currentTimeMillis() - start));
		
		start = System.currentTimeMillis();
		for (int i = 0; i < num; i++) {
			String sig = MBeanMetaData.getMethodSignature("foo2", SIGS);
			Method m2 = (Method) map.get(sig);
			m2.invoke(hello, ARGS);
		}
		System.out.println("metaData:" + (System.currentTimeMillis() - start));
    }

    protected void setUp() throws Exception {
    	super.setUp();
    }


    protected void tearDown() throws Exception {
    	super.tearDown();
    }


    public static Test suite() {
        return new TestSuite(MBeanMetaDataTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MBeanMetaDataTest.class.getName()});
    }
}
