package test.org.seasar.nazuna;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.LocalType;
import org.seasar.nazuna.Var;
import org.seasar.nazuna.VarType;
import org.seasar.util.SeasarRuntimeException;

public class LocalTypeTest extends TestCase {

    public LocalTypeTest(String name) {
        super(name);
    }
    
    public void testCreateVars() throws Exception {
    	LocalType localType = new LocalType();
    	VarType varType = new VarType("a", String.class);
    	varType.setDefaultValue("111");
    	VarType varType2 = new VarType("b", Integer.class);
    	localType.addVarType(varType);
    	localType.addVarType(varType2);
    	Map vars = localType.createVars();
    	assertEquals("1", 2, vars.size());
    	Var a = (Var) vars.get("a");
    	assertNotNull("2", a);
    	assertEquals("3", "111", a.getValue());
    	Var b = (Var) vars.get("b");
    	assertNotNull("4", b);
    	assertEquals("5", null, b.getValue());
    }
    
    public void testAddVarType() throws Exception {
    	LocalType localType = new LocalType();
    	VarType varType = new VarType("a", String.class);
    	localType.addVarType(varType);
    	try {
    		localType.addVarType(varType);
    		fail("1");
    	} catch (SeasarRuntimeException ex) {
    		System.out.println(ex);
    	}
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(LocalTypeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{LocalTypeTest.class.getName()});
    }
}