package test.org.seasar.nazuna;

import junit.framework.*;
import java.util.*;
import java.math.*;
import org.seasar.util.*;
import org.seasar.nazuna.*;

public class GroupValueTest extends TestCase {

    public GroupValueTest(String name) throws Exception {
        super(name);
    }

    public void testCount() throws Exception {
    	List items = new EArrayList();
    	items.add(new EMap());
    	items.add(new EMap());
    	items.add(new EMap());
        GroupElement allCount = new GroupElement("AllCount", GroupType.COUNT, null);
        GroupValue allCountValue = allCount.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            allCountValue.calculate(items.get(i));
        }
        assertEquals("1", new Integer(3), allCountValue.getValue());
    }
    
    public void testCount2() throws Exception {
    	List items = new EArrayList();
    	items.add(new EMap());
    	items.add(new EMap());
    	Map item = new EMap();
    	item.put("a", "1");
    	items.add(item);
        GroupElement aCount = new GroupElement("ACount", GroupType.COUNT, "a");
        GroupValue aCountValue = aCount.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            aCountValue.calculate(items.get(i));
        }
        assertEquals("1", new Integer(1), aCountValue.getValue());
    }
    
    public void testSum() throws Exception {
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(2));
    	items.add(item);
    	items.add(new EMap());
        GroupElement aSum = new GroupElement("ASum", GroupType.SUM, "a");
        GroupValue aSumValue = aSum.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            aSumValue.calculate(items.get(i));
        }
        assertEquals("1", new BigDecimal(3), aSumValue.getValue());
    }
    
    public void testMax() throws Exception {
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(2));
    	items.add(item);
    	items.add(new EMap());
        GroupElement aMax = new GroupElement("AMax", GroupType.MAX, "a");
        GroupValue aMaxValue = aMax.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            aMaxValue.calculate(items.get(i));
        }
        assertEquals("1", new Integer(2), aMaxValue.getValue());
    }
    
    public void testMin() throws Exception {
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(2));
    	items.add(item);
    	items.add(new EMap());
        GroupElement aMin = new GroupElement("AMim", GroupType.MIN, "a");
        GroupValue aMinValue = aMin.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            aMinValue.calculate(items.get(i));
        }
        assertEquals("1", new Integer(1), aMinValue.getValue());
    }
    
    public void testAvg() throws Exception {
    	List items = new EArrayList();
    	Map item = new EMap();
    	item.put("a", new Integer(1));
    	items.add(item);
    	item = new EMap();
    	item.put("a", new Integer(2));
    	items.add(item);
    	items.add(new EMap());
        GroupElement aAvg = new GroupElement("AAvg", GroupType.AVG, "a");
        GroupValue aAvgValue = aAvg.newGroupValue();
        for (int i = 0; i < items.size(); ++i) {
            aAvgValue.calculate(items.get(i));
        }
        assertEquals("1", new BigDecimal(1.5), aAvgValue.getValue());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(GroupValueTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{GroupValueTest.class.getName()});
    }
}
