package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class AddSubExp implements Expression {

    private final Expression _arg1Exp;
    private final Expression _arg2Exp;
    private final int _token;

    public AddSubExp(final Expression arg1Exp, final Expression arg2Exp, int token) {
    	Assertion.assertNotNull("arg1Exp", arg1Exp);
    	Assertion.assertNotNull("arg2Exp", arg2Exp);
    	Assertion.assertTrue(token == RuleTokenizer.ADD || token == RuleTokenizer.SUBTRACT,
    		"ESSR0003", "token", RuleTokenizer.getTokenName(token));

        _arg1Exp = arg1Exp;
        _arg2Exp = arg2Exp;
        _token = token;
    }

	
    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        Number arg1 = (Number) _arg1Exp.evaluateValue(ruleContext);
        Number arg2 = (Number) _arg2Exp.evaluateValue(ruleContext);
        switch (_token) {
        	case RuleTokenizer.ADD:
        		return MathUtil.add(arg1, arg2);
        	default:
        		return MathUtil.subtract(arg1, arg2);
        }
    }
}