package org.seasar.nazuna;


public abstract class AbstractRuleStatement implements RuleStatement {
	
	private Object _parent;
	private String _location;
	
	public AbstractRuleStatement(Object parent, String location) {
		_parent = parent;
		_location = location;	
	}
	
	public final Object getParent() {
		return _parent;
	}

	public final String getLocation() {
		return _location;
	}
	
	public Object findAncestor(Class clazz) {
		if (_parent == null) {
			return null;
		}
		if (clazz.isInstance(_parent)) {
			return _parent;
		}
		if (_parent instanceof RuleStatement) {
			return ((RuleStatement) _parent).findAncestor(clazz);
		}
		return null;
	}
}
