/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.util.DecodeUtil;
import org.seasar.jsf.util.RenderUtil;
import org.seasar.jsf.util.SelectItemUtil;
import org.seasar.jsf.util.UIValueUtil;
import org.seasar.jsf.util.ValueHolderUtil;

public class HtmlSelectManyCheckboxRenderer
extends Renderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.renderSelectManyCheckbox(context, (HtmlSelectManyCheckbox)component);
    }

    protected void renderSelectManyCheckbox(FacesContext context, HtmlSelectManyCheckbox component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)component);
        RenderUtil.renderIdIfNecessary(writer, (UIComponent)component, context);
        writer.writeAttribute("name", (Object)component.getClientId(context), null);
        boolean pageDirection = "pageDirection".equals(component.getLayout());
        if (!pageDirection) {
            writer.startElement("tr", null);
        }
        RenderUtil.renderAttributes(writer, (UIComponent)component, JsfConstants.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (component.isDisabled()) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        this.renderSelectManyCheckbox(context, (UIOutput)component, pageDirection);
        if (!pageDirection) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected List getLookupAsString(FacesContext context, UIComponent component) {
        String[] valueStrArray = ValueHolderUtil.getValueAsStringArray(context, component);
        ArrayList<String> lookupAsString = new ArrayList<String>();
        if (valueStrArray != null) {
            int i = 0;
            while (i < valueStrArray.length) {
                lookupAsString.add(valueStrArray[i]);
                ++i;
            }
        }
        return lookupAsString;
    }

    public void decode(FacesContext context, UIComponent component) {
        DecodeUtil.decodeMany(context, component);
    }

    protected void renderSelectManyCheckbox(FacesContext context, UIOutput component, boolean pageDirection) throws IOException {
        List selectItemList = SelectItemUtil.getSelectItemList((UIComponent)component);
        List lookupAsString = this.getLookupAsString(context, (UIComponent)component);
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            if (pageDirection) {
                writer.startElement("tr", null);
            }
            writer.startElement("td", null);
            SelectItem selectItem = (SelectItem)it.next();
            this.renderCheckbox(context, component, selectItem, lookupAsString);
            writer.endElement("td");
            if (!pageDirection) continue;
            writer.endElement("tr");
        }
    }

    protected void renderCheckbox(FacesContext context, UIOutput component, SelectItem selectItem, List lookupAsString) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = component.getConverter();
        Object itemValue = selectItem.getValue();
        String itemStrValue = UIValueUtil.getValueAsString(context, (UIComponent)component, itemValue, converter);
        writer.startElement("label", null);
        writer.startElement("input", (UIComponent)component);
        writer.writeAttribute("name", (Object)component.getClientId(context), null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (itemStrValue != null) {
            writer.writeAttribute("value", (Object)itemStrValue, null);
        }
        if (lookupAsString.contains(itemStrValue)) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (selectItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.writeText((Object)selectItem.getLabel(), null);
        writer.endElement("label");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return RenderUtil.getConvertedUIOutputValues(context, (UIOutput)component, submittedValue);
    }
}

