package org.seasar.framework.exception;

import javax.transaction.xa.XAException;

import org.seasar.framework.message.MessageFormatter;

/**
 * @author higa
 *
 */
public class SXAException extends XAException {

	private String messageCode_;
	private Object[] messageArgs_;
	
	public SXAException(Throwable t) {
		this("ESSR0017", new Object[]{t}, t);
	}

	public SXAException(String messageCode, Object[] messageArgs) {
		this(messageCode, messageArgs, null);
	}

	public SXAException(String messageCode, Object[] messageArgs,
		Throwable t) {

		super(MessageFormatter.getMessage(messageCode, messageArgs));
		messageCode_ = messageCode;
		messageArgs_ = messageArgs;
		initCause(t);
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getMessageArgs() {
		return messageArgs_;
	}
}
