/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import junit.textui.TestRunner;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.deployer.ComponentDeployer;
import org.seasar.framework.container.deployer.OuterComponentDeployer;
import org.seasar.framework.container.deployer.PrototypeComponentDeployer;
import org.seasar.framework.container.deployer.RequestComponentDeployer;
import org.seasar.framework.container.deployer.SessionComponentDeployer;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.util.InstanceModeUtil;

public class ComponentDeployerFactory {
    private static Provider provider_ = new DefaultProvider();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.framework.container.deployer.ComponentDeployerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static ComponentDeployer create(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createComponentDeployer(cd);
    }

    public interface Provider {
        public ComponentDeployer createComponentDeployer(ComponentDef var1);
    }

    public static class DefaultProvider
    implements Provider {
        public ComponentDeployer createComponentDeployer(ComponentDef cd) {
            String instanceMode = cd.getInstanceMode();
            if (InstanceModeUtil.isSingleton(instanceMode)) {
                return this.createSingletonComponentDeployer(cd);
            }
            if (InstanceModeUtil.isPrototype(instanceMode)) {
                return this.createPrototypeComponentDeployer(cd);
            }
            if (InstanceModeUtil.isRequest(instanceMode)) {
                return this.createRequestComponentDeployer(cd);
            }
            if (InstanceModeUtil.isSession(instanceMode)) {
                return this.createSessionComponentDeployer(cd);
            }
            if (InstanceModeUtil.isOuter(instanceMode)) {
                return this.createOuterComponentDeployer(cd);
            }
            return this.createDefaultComponentDeployer(cd);
        }

        protected ComponentDeployer createSingletonComponentDeployer(ComponentDef cd) {
            return new SingletonComponentDeployer(cd);
        }

        protected ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
            return new PrototypeComponentDeployer(cd);
        }

        protected ComponentDeployer createRequestComponentDeployer(ComponentDef cd) {
            return new RequestComponentDeployer(cd);
        }

        protected ComponentDeployer createSessionComponentDeployer(ComponentDef cd) {
            return new SessionComponentDeployer(cd);
        }

        protected ComponentDeployer createOuterComponentDeployer(ComponentDef cd) {
            return new OuterComponentDeployer(cd);
        }

        protected ComponentDeployer createDefaultComponentDeployer(ComponentDef cd) {
            return this.createOuterComponentDeployer(cd);
        }
    }
}

