/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import org.seasar.dao.DtoMetaData;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.FieldUtil;

public class DtoMetaDataImpl
implements DtoMetaData {
    private Class beanClass_;
    private CaseInsensitiveMap propertyTypes_ = new CaseInsensitiveMap();

    protected DtoMetaDataImpl() {
    }

    public DtoMetaDataImpl(Class beanClass) {
        this.beanClass_ = beanClass;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)beanClass);
        this.setupPropertyType(beanDesc);
    }

    public Class getBeanClass() {
        return this.beanClass_;
    }

    protected void setBeanClass(Class beanClass) {
        this.beanClass_ = beanClass;
    }

    public int getPropertyTypeSize() {
        return this.propertyTypes_.size();
    }

    public PropertyType getPropertyType(int index) {
        return (PropertyType)this.propertyTypes_.get(index);
    }

    public PropertyType getPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypes_.get((Object)propertyName);
        if (propertyType == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass_, propertyName);
        }
        return propertyType;
    }

    public boolean hasPropertyType(String propertyName) {
        return this.propertyTypes_.get((Object)propertyName) != null;
    }

    protected void setupPropertyType(BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            PropertyType pt = this.createPropertyType(beanDesc, pd);
            this.addPropertyType(pt);
            ++i;
        }
    }

    protected PropertyType createPropertyType(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        String columnNameKey = String.valueOf(propertyDesc.getPropertyName()) + "_COLUMN";
        String columnName = propertyDesc.getPropertyName();
        if (beanDesc.hasField(columnNameKey)) {
            Field field = beanDesc.getField(columnNameKey);
            columnName = (String)FieldUtil.get((Field)field, null);
        }
        ValueType valueType = ValueTypes.getValueType((Class)propertyDesc.getPropertyType());
        PropertyTypeImpl pt = new PropertyTypeImpl(propertyDesc, valueType, columnName);
        return pt;
    }

    protected void addPropertyType(PropertyType propertyType) {
        this.propertyTypes_.put((Object)propertyType.getPropertyName(), (Object)propertyType);
    }
}

