/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.validator.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.rule.CommonNamingRule;
import org.seasar.struts.validator.config.ConfigRegister;
import org.seasar.struts.validator.factory.ValidatorAnnotationHandler;

public abstract class AbstractValidatorAnnotationHandler
implements ValidatorAnnotationHandler {
    private static final String VALIDATOR_TYPE_PREFIX_RE = "Type$";
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public Form createForm(String formName, Class formClass) {
        Form form = new Form();
        form.setName(formName);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)formClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
            Field field = this.createField(form, beanDesc, propDesc);
            if (field == null) continue;
            form.addField(field);
        }
        return form;
    }

    protected abstract Field createField(Form var1, BeanDesc var2, PropertyDesc var3);

    protected String getAutoTypeValidatorName(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        Class<?> paramType = classes[classes.length - 1];
        if (paramType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractValidatorAnnotationHandler.class$("java.lang.Byte")) : class$java$lang$Byte) || paramType.equals(Byte.TYPE)) {
            return "byte";
        }
        if (paramType.equals(class$java$util$Date == null ? (class$java$util$Date = AbstractValidatorAnnotationHandler.class$("java.util.Date")) : class$java$util$Date) || paramType.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = AbstractValidatorAnnotationHandler.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return "date";
        }
        if (paramType.equals(class$java$lang$Double == null ? (class$java$lang$Double = AbstractValidatorAnnotationHandler.class$("java.lang.Double")) : class$java$lang$Double) || paramType.equals(Double.TYPE)) {
            return "double";
        }
        if (paramType.equals(class$java$lang$Float == null ? (class$java$lang$Float = AbstractValidatorAnnotationHandler.class$("java.lang.Float")) : class$java$lang$Float) || paramType.equals(Float.TYPE)) {
            return "float";
        }
        if (paramType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractValidatorAnnotationHandler.class$("java.lang.Integer")) : class$java$lang$Integer) || paramType.equals(Integer.TYPE)) {
            return "integer";
        }
        if (paramType.equals(class$java$lang$Long == null ? (class$java$lang$Long = AbstractValidatorAnnotationHandler.class$("java.lang.Long")) : class$java$lang$Long) || paramType.equals(Long.TYPE)) {
            return "long";
        }
        if (paramType.equals(class$java$lang$Short == null ? (class$java$lang$Short = AbstractValidatorAnnotationHandler.class$("java.lang.Short")) : class$java$lang$Short) || paramType.equals(Short.TYPE)) {
            return "short";
        }
        return null;
    }

    protected void registAutoTypeValidatorConfig(Field field, Method method) {
        String autoTypeValidatorName = this.getAutoTypeValidatorName(method);
        if (StringUtil.isEmpty((String)autoTypeValidatorName)) {
            return;
        }
        if (this.hasConfigRegister(autoTypeValidatorName)) {
            this.executeConfigRegister(field, autoTypeValidatorName, new HashMap());
        }
    }

    protected boolean hasConfigRegister(String validatorName) {
        String registerName = this.getConfigRegisterName(validatorName);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        return container.hasComponentDef((Object)registerName);
    }

    protected void executeConfigRegister(Field field, String validatorName, Map parameters) {
        String registerName = this.getConfigRegisterName(validatorName);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ConfigRegister register = (ConfigRegister)container.getComponent((Object)registerName);
        register.regist(field, parameters);
    }

    protected String getValidatorName(Class clazz) {
        String validatorName = CommonNamingRule.decapitalizeName(ClassUtil.getShortClassName((Class)clazz));
        return validatorName.replaceFirst(VALIDATOR_TYPE_PREFIX_RE, "");
    }

    protected String[] toArrays(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    private String getConfigRegisterName(String validatorName) {
        return validatorName + "ConfigRegister";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

