/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.GenericServlet;
import org.apache.log4j.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.struts.util.ClassFinder;

public class ClassFinderImpl
implements ClassFinder {
    private static final Logger logger = Logger.getLogger((Class)(class$org$seasar$struts$util$ClassFinderImpl == null ? (class$org$seasar$struts$util$ClassFinderImpl = ClassFinderImpl.class$("org.seasar.struts.util.ClassFinderImpl")) : class$org$seasar$struts$util$ClassFinderImpl));
    private static final String CLASS_FILE_EXTENTION = ".class";
    private static final int CLASS_FILE_EXTENTION_LENGTH = ".class".length();
    private static final char FILE_SEPARATOR = File.separatorChar;
    private static final String WEB_CLASSES_DIR = "/WEB-INF/classes";
    private static final String WEB_LIB_DIR = "/WEB-INF/lib";
    private static final String ALL_MATCHE_PATTERN = ".*";
    private Collection classCollection = new ArrayList();
    static /* synthetic */ Class class$org$seasar$struts$util$ClassFinderImpl;

    public void find() {
        this.find(ALL_MATCHE_PATTERN);
    }

    public void find(String pattern) {
        this.find(true, pattern);
    }

    public void find(boolean enableJar, String pattern) {
        String cp = System.getProperty("java.class.path");
        String ps = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(cp, ps);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            this.loadAllClass(path, enableJar, pattern);
        }
    }

    public void find(boolean enableJar) {
        this.find(enableJar, ALL_MATCHE_PATTERN);
    }

    public void find(String path, boolean enableJar, String pattern) {
        this.loadAllClass(path, enableJar, pattern);
    }

    public void find(String path, boolean enableJar) {
        this.find(path, enableJar, ALL_MATCHE_PATTERN);
    }

    public void find(File file, boolean enableJar, String pattern) {
        this.loadAllClass(file.getAbsolutePath(), enableJar, pattern);
    }

    public void find(File file, boolean enableJar) {
        this.find(file.getAbsolutePath(), enableJar, ALL_MATCHE_PATTERN);
    }

    public void find(GenericServlet servlet, boolean enableJar) {
        this.find(servlet, enableJar, ALL_MATCHE_PATTERN);
    }

    public void find(GenericServlet servlet, boolean enableJar, String pattern) {
        String classesDirPath = servlet.getServletContext().getRealPath(WEB_CLASSES_DIR);
        this.find(classesDirPath, enableJar, pattern);
        String libDirPath = servlet.getServletContext().getRealPath(WEB_LIB_DIR);
        File[] files = new File(libDirPath).listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.find(files[i], enableJar, pattern);
            }
        }
    }

    private void loadAllClass(String classpath, boolean enableJar, String pattern) {
        File path = new File(classpath);
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            this.loadFromDir(path, path, pattern);
        } else if (enableJar) {
            this.loadFromJar(path, pattern);
        }
    }

    private void loadFromJar(File path, String pattern) {
        JarFile jarFile = ClassFinderImpl.createJarFileInstance(path);
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            if (!entryName.endsWith(CLASS_FILE_EXTENTION)) continue;
            String classResourceName = entryName;
            Class clazz = ClassFinderImpl.forResourceName(classResourceName);
            this.addToCollection(clazz, pattern);
        }
    }

    private static JarFile createJarFileInstance(File path) {
        try {
            return new JarFile(path);
        }
        catch (IOException e) {
            logger.warn((Object)e.toString());
            return null;
        }
    }

    private void loadFromDir(File rootPath, File path, String pattern) {
        File[] files = path.listFiles();
        int rootPathDirNameLength = rootPath.getAbsolutePath().length() + 1;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.loadFromDir(rootPath, files[i], pattern);
                continue;
            }
            if (!files[i].getName().endsWith(CLASS_FILE_EXTENTION)) continue;
            String classFilePath = files[i].getAbsolutePath();
            String classResourceName = classFilePath.substring(rootPathDirNameLength);
            Class clazz = ClassFinderImpl.forResourceName(classResourceName);
            this.addToCollection(clazz, pattern);
        }
    }

    private synchronized void addToCollection(Class clazz, String pattern) {
        if (clazz == null) {
            return;
        }
        if (clazz.getName().matches(pattern)) {
            this.classCollection.add(clazz);
        }
    }

    private static final Class forResourceName(String classResourceName) {
        String className = classResourceName.substring(0, classResourceName.length() - CLASS_FILE_EXTENTION_LENGTH);
        className = className.replace(FILE_SEPARATOR, '.');
        className = className.replace('/', '.');
        try {
            Class clazz = ClassUtil.forName((String)className);
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            logger.warn((Object)e.toString());
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn((Object)e.toString());
            return null;
        }
    }

    public synchronized Collection getClassCollection() {
        return this.classCollection;
    }

    public synchronized void destroy() {
        this.classCollection = new ArrayList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

