/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.deployer.OuterComponentDeployer;
import org.seasar.framework.container.deployer.PrototypeComponentDeployer;
import org.seasar.framework.container.deployer.RequestComponentDeployer;
import org.seasar.framework.container.deployer.SessionComponentDeployer;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;

public class ComponentDeployerFactory {
    private static Provider provider_ = new DefaultProvider();

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static ComponentDeployer createSingletonComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createSingletonComponentDeployer(cd);
    }

    public static ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createPrototypeComponentDeployer(cd);
    }

    public static ComponentDeployer createSessionComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createSessionComponentDeployer(cd);
    }

    public static ComponentDeployer createRequestComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createRequestComponentDeployer(cd);
    }

    public static ComponentDeployer createOuterComponentDeployer(ComponentDef cd) {
        return ComponentDeployerFactory.getProvider().createOuterComponentDeployer(cd);
    }

    public static interface Provider {
        public ComponentDeployer createSingletonComponentDeployer(ComponentDef var1);

        public ComponentDeployer createPrototypeComponentDeployer(ComponentDef var1);

        public ComponentDeployer createSessionComponentDeployer(ComponentDef var1);

        public ComponentDeployer createRequestComponentDeployer(ComponentDef var1);

        public ComponentDeployer createOuterComponentDeployer(ComponentDef var1);
    }

    public static class DefaultProvider
    implements Provider {
        public ComponentDeployer createSingletonComponentDeployer(ComponentDef cd) {
            return new SingletonComponentDeployer(cd);
        }

        public ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
            return new PrototypeComponentDeployer(cd);
        }

        public ComponentDeployer createRequestComponentDeployer(ComponentDef cd) {
            return new RequestComponentDeployer(cd);
        }

        public ComponentDeployer createSessionComponentDeployer(ComponentDef cd) {
            return new SessionComponentDeployer(cd);
        }

        public ComponentDeployer createOuterComponentDeployer(ComponentDef cd) {
            return new OuterComponentDeployer(cd);
        }

        public ComponentDeployer createDefaultComponentDeployer(ComponentDef cd) {
            return this.createOuterComponentDeployer(cd);
        }
    }
}

