/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractAnnotationHandler
implements AnnotationHandler {
    protected static final String COMPONENT = "COMPONENT";
    protected static final String NAME = "name";
    protected static final String INSTANCE = "instance";
    protected static final String AUTO_BINDING = "autoBinding";
    protected static final String BINDING_SUFFIX = "_BINDING";
    protected static final String BINDING_TYPE = "bindingType";
    protected static final String VALUE = "value";
    protected static final String ASPECT = "ASPECT";
    protected static final String INTERCEPTOR = "interceptor";
    protected static final String POINTCUT = "pointcut";

    public ComponentDef createComponentDef(String className) {
        return this.createComponentDef(ClassUtil.forName(className));
    }

    public ComponentDef createComponentDefWithDI(String className) {
        return this.createComponentDefWithDI(ClassUtil.forName(className));
    }

    public ComponentDef createComponentDefWithDI(Class componentClass) {
        ComponentDef componentDef = this.createComponentDef(componentClass);
        this.appendDI(componentDef);
        return componentDef;
    }

    public void appendDI(ComponentDef componentDef) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentDef.getComponentClass());
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            PropertyDef propDef;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasWriteMethod() && (propDef = this.createPropertyDef(beanDesc, pd)) != null) {
                componentDef.addPropertyDef(propDef);
            }
            ++i;
        }
        this.appendAspect(componentDef);
    }

    protected PropertyDef createPropertyDef(String propertyName, String bindingTypeName, String expression) {
        PropertyDefImpl propertyDef = new PropertyDefImpl(propertyName);
        if (!StringUtil.isEmpty(bindingTypeName)) {
            BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef(bindingTypeName);
            propertyDef.setBindingTypeDef(bindingTypeDef);
        }
        if (!StringUtil.isEmpty(expression)) {
            propertyDef.setExpression(expression);
        }
        return propertyDef;
    }
}

