/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.autoregister.AutoNaming;
import org.seasar.framework.container.autoregister.AutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class FileSystemComponentAutoRegister
extends AutoRegister {
    private static final String CLASS_SUFFIX = ".class";
    private String fileNameOfRoot = "app.dicon";
    private AutoNaming autoNaming;

    public void setFileNameOfRoot(String fileNameOfRoot) {
        this.fileNameOfRoot = fileNameOfRoot;
    }

    public void setAutoNaming(AutoNaming autoNaming) {
        this.autoNaming = autoNaming;
    }

    public void registAll() {
        int i = 0;
        while (i < this.getClassPatternSize()) {
            ClassPattern cp = this.getClassPattern(i);
            this.regist(cp);
            ++i;
        }
    }

    protected void regist(ClassPattern classPattern) {
        String packageName = classPattern.getPackageName();
        File packageDir = this.getPackageDir(packageName);
        this.regist(classPattern, packageDir, packageName);
    }

    protected void regist(ClassPattern classPattern, File packageDir, String packageName) {
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        File[] files = packageDir.listFiles();
        int i = 0;
        while (i < files.length) {
            String shortClassName;
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                this.regist(classPattern, file, packageName == null ? fileName : String.valueOf(packageName) + "." + fileName);
            } else if (fileName.endsWith(CLASS_SUFFIX) && !this.isIgnore(packageName, shortClassName = fileName.substring(0, fileName.length() - CLASS_SUFFIX.length())) && classPattern.isApplied(shortClassName)) {
                String className = packageName == null ? shortClassName : String.valueOf(packageName) + "." + shortClassName;
                ComponentDef cd = annoHandler.createComponentDef(className);
                if (cd.getComponentName() == null && this.autoNaming != null) {
                    cd.setComponentName(this.autoNaming.defineName(packageName, shortClassName));
                }
                if (!this.hasComponentDef(cd.getComponentName())) {
                    annoHandler.appendDI(cd);
                    this.getContainer().register(cd);
                }
            }
            ++i;
        }
    }

    protected File getPackageDir(String packageName) {
        File packageDir = this.getRootDir();
        if (packageName != null) {
            String[] names = StringUtil.split(packageName, ".");
            int i = 0;
            while (i < names.length) {
                packageDir = new File(packageDir, names[i]);
                ++i;
            }
        }
        return packageDir;
    }

    protected File getRootDir() {
        return ResourceUtil.getResourceAsFile(this.fileNameOfRoot).getParentFile();
    }
}

