/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.ArrayList;
import java.util.List;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.ClassPattern;

public class AutoRegister {
    private S2Container container;
    private List classPatterns = new ArrayList();
    private List ignoreClassPatterns = new ArrayList();

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public int getClassPatternSize() {
        return this.classPatterns.size();
    }

    public ClassPattern getClassPattern(int index) {
        return (ClassPattern)this.classPatterns.get(index);
    }

    public void addClassPattern(String packageName, String shortClassName) {
        this.addClassPattern(new ClassPattern(packageName, shortClassName));
    }

    public void addClassPattern(ClassPattern classPattern) {
        this.classPatterns.add(classPattern);
    }

    public void addIgnoreClassPattern(String packageName, String shortClassName) {
        this.addIgnoreClassPattern(new ClassPattern(packageName, shortClassName));
    }

    public void addIgnoreClassPattern(ClassPattern classPattern) {
        this.ignoreClassPatterns.add(classPattern);
    }

    protected boolean hasComponentDef(String name) {
        return this.findComponentDef(name) != null;
    }

    protected ComponentDef findComponentDef(String name) {
        if (name == null) {
            return null;
        }
        S2Container container = this.getContainer();
        int i = 0;
        while (i < container.getComponentDefSize()) {
            ComponentDef cd = container.getComponentDef(i);
            if (name.equals(cd.getComponentName())) {
                return cd;
            }
            ++i;
        }
        return null;
    }

    protected boolean isIgnore(String packageName, String shortClassName) {
        if (this.ignoreClassPatterns.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.ignoreClassPatterns.size()) {
            ClassPattern cp = (ClassPattern)this.ignoreClassPatterns.get(i);
            if (cp.isSamePackageName(packageName) && cp.isApplied(shortClassName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

