/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.util.ResourceNotFoundRuntimeException;

public abstract class AbstractS2ContainerBuilder
implements S2ContainerBuilder {
    protected ResourceResolver resourceResolver_ = new ClassPathResourceResolver();

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver_;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver_ = resourceResolver;
    }

    public S2Container build(String path, ClassLoader classLoader) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            S2Container s2Container = this.build(path);
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            return s2Container;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    protected InputStream getInputStream(String path) {
        InputStream is = this.resourceResolver_.getInputStream(path);
        if (is == null) {
            throw new ResourceNotFoundRuntimeException(path);
        }
        return is;
    }
}

