/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.reader.bytecode;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.backport175.reader.bytecode.spi.BytecodeProvider;

public class DefaultBytecodeProvider
implements BytecodeProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytecode(String className, ClassLoader loader) throws Exception {
        byte[] bytes;
        InputStream in = null;
        try {
            try {
                in = loader != null ? loader.getResourceAsStream(className.replace('.', '/') + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
                if (in == null) throw new Exception("could not read class [" + className + "] as byte array");
                bytes = this.toByteArray(in);
                Object var7_5 = null;
            }
            catch (IOException e) {
                throw new Exception("could not read class [" + className + "]as byte array due to: " + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        in.close();
        return bytes;
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        byte[] bytes = new byte[in.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = in.read(bytes, len, bytes.length - len)) == -1) {
                if (len < bytes.length) {
                    c = new byte[len];
                    System.arraycopy(bytes, 0, c, 0, len);
                    bytes = c;
                }
                return bytes;
            }
            if ((len += n) != bytes.length) continue;
            c = new byte[bytes.length + 1000];
            System.arraycopy(bytes, 0, c, 0, len);
            bytes = c;
        }
    }
}

