/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler;

import org.codehaus.backport175.com.thoughtworks.qdox.model.DocletTag;
import org.codehaus.backport175.compiler.javadoc.RawAnnotation;

public class SourceLocation {
    private String m_className;
    private String m_file;
    private int m_lineNumber;
    private String m_annotationClassName;

    public static SourceLocation render(RawAnnotation annotation) {
        SourceLocation sourceLocation = new SourceLocation();
        sourceLocation.m_className = annotation.getEnclosingClassName();
        sourceLocation.m_file = annotation.getEnclosingClassFile();
        sourceLocation.m_lineNumber = annotation.getLineNumber();
        sourceLocation.m_annotationClassName = annotation.getName();
        return sourceLocation;
    }

    public static SourceLocation render(Class annotationClass, DocletTag tag, String enclosingClassName, String enclosingClassFileName) {
        SourceLocation sourceLocation = new SourceLocation();
        sourceLocation.m_className = enclosingClassName;
        sourceLocation.m_file = enclosingClassFileName;
        sourceLocation.m_lineNumber = tag.getLineNumber();
        sourceLocation.m_annotationClassName = annotationClass.getName();
        return sourceLocation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_className);
        sb.append(':');
        sb.append(this.m_lineNumber);
        sb.append(" @");
        sb.append(this.m_annotationClassName);
        sb.append(" in file [");
        sb.append(this.m_file);
        sb.append(']');
        return sb.toString();
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getAnnnotationClassName() {
        return this.m_annotationClassName;
    }

    public int getLine() {
        return this.m_lineNumber;
    }

    public String getFile() {
        return this.m_file;
    }
}

