/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.config.rule;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.action.StrutsAction;
import org.seasar.struts.config.AutoStrutsConfigRule;
import org.seasar.struts.config.rule.CommonNamingRule;
import org.seasar.struts.config.rule.ZeroConfigActionRule;

public class ZeroConfigActionRuleImpl
implements ZeroConfigActionRule {
    private AutoStrutsConfigRule configRule;

    public String getPath(Class actionClass, ModuleConfig config) {
        String path = ClassUtil.getShortClassName((Class)actionClass);
        return "/" + CommonNamingRule.decapitalizeName(path).replaceFirst("Action$", "");
    }

    public String getName(Class actionClass, ModuleConfig config) {
        String name = ClassUtil.getShortClassName((Class)actionClass);
        name = CommonNamingRule.decapitalizeName(name).replaceFirst("Action$", "");
        String formName = name + "Form";
        String dtoName = name + "Dto";
        if (config.findFormBeanConfig(formName) != null) {
            return formName;
        }
        if (config.findFormBeanConfig(dtoName) != null) {
            return dtoName;
        }
        if (config.findFormBeanConfig(name) != null) {
            return name;
        }
        return StrutsAction.DEFAULT_NAME;
    }

    public String getScope(Class actionClass, ModuleConfig config) {
        return "request";
    }

    public boolean getValidate(Class actionClass, ModuleConfig config) {
        return true;
    }

    public String getInput(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_INPUT;
    }

    public String getParameter(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_PARAMETER;
    }

    public String getAttribute(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_ATTRIBUTE;
    }

    public String getForward(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_FORWARD;
    }

    public String getInclude(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_INCLUDE;
    }

    public String getPrefix(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_PREFIX;
    }

    public String getSuffix(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_SUFFIX;
    }

    public boolean getUnknown(Class actionClass, ModuleConfig config) {
        return false;
    }

    public String getRoles(Class actionClass, ModuleConfig config) {
        return StrutsAction.DEFAULT_ROLES;
    }

    public void addFowardConfig(Class actionClass, ActionConfig actionConfig, ServletContext servletContext) {
        ForwardConfig forwardConfig = actionConfig.findForwardConfig("success");
        if (forwardConfig != null) {
            return;
        }
        String path = null;
        String[] viewExtention = this.configRule.getViewExtention();
        for (int i = 0; i < viewExtention.length; ++i) {
            String file = this.getPath(actionClass, null) + "." + viewExtention[i];
            path = this.configRule.getDocRoot() + file;
            String packageDir = "/" + actionClass.getPackage().getName().replace('.', '/');
            path = this.getExistFilePath(this.configRule.getDocRoot(), packageDir, file, actionConfig, servletContext);
            if (path != null) break;
        }
        this.addFowardConfig(path, actionConfig);
    }

    private void addFowardConfig(String path, ActionConfig actionConfig) {
        ActionForward forwardConfig = new ActionForward();
        forwardConfig.setName("success");
        forwardConfig.setPath(path);
        forwardConfig.setRedirect(false);
        actionConfig.addForwardConfig((ForwardConfig)forwardConfig);
    }

    private String getExistFilePath(String docRoot, String packageDir, String file, ActionConfig actionConfig, ServletContext servletContext) {
        String path = docRoot + packageDir + file;
        if (new File(servletContext.getRealPath(path)).exists()) {
            return path;
        }
        if (StringUtil.isEmpty((String)packageDir)) {
            if (this.isLastExtention(file) && actionConfig.findForwardConfigs().length == 0) {
                throw new IllegalStateException("View file was not found." + new File(path).getAbsolutePath());
            }
            return null;
        }
        int index = packageDir.indexOf("/", 1);
        packageDir = packageDir.substring(index + 1);
        packageDir = index < 0 ? "" : "/" + packageDir;
        return this.getExistFilePath(docRoot, packageDir, file, actionConfig, servletContext);
    }

    private boolean isLastExtention(String file) {
        return file.endsWith(this.configRule.getViewExtention()[this.configRule.getViewExtention().length - 1]);
    }

    public void setAutoStrutsConfigPattern(AutoStrutsConfigRule configRule) {
        this.configRule = configRule;
    }
}

