/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.assembler.AutoConstructorAssembler;
import org.seasar.framework.container.assembler.AutoPropertyAssembler;
import org.seasar.framework.container.assembler.ConstructorAssembler;
import org.seasar.framework.container.assembler.DefaultConstructorAssembler;
import org.seasar.framework.container.assembler.DefaultDestroyMethodAssembler;
import org.seasar.framework.container.assembler.DefaultInitMethodAssembler;
import org.seasar.framework.container.assembler.DefaultPropertyAssembler;
import org.seasar.framework.container.assembler.ExpressionConstructorAssembler;
import org.seasar.framework.container.assembler.ManualConstructorAssembler;
import org.seasar.framework.container.assembler.ManualPropertyAssembler;
import org.seasar.framework.container.assembler.MethodAssembler;
import org.seasar.framework.container.assembler.PropertyAssembler;
import org.seasar.framework.container.util.AutoBindingUtil;

public class AssemblerFactory {
    private static Provider provider_ = new DefaultProvider();

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static ConstructorAssembler createConstructorAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createConstructorAssembler(cd);
    }

    public static PropertyAssembler createPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createPropertyAssembler(cd);
    }

    public static MethodAssembler createInitMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createInitMethodAssembler(cd);
    }

    public static MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createDestroyMethodAssembler(cd);
    }

    public interface Provider {
        public ConstructorAssembler createConstructorAssembler(ComponentDef var1);

        public PropertyAssembler createPropertyAssembler(ComponentDef var1);

        public MethodAssembler createInitMethodAssembler(ComponentDef var1);

        public MethodAssembler createDestroyMethodAssembler(ComponentDef var1);
    }

    public static class DefaultProvider
    implements Provider {
        public ConstructorAssembler createConstructorAssembler(ComponentDef cd) {
            if (cd.getArgDefSize() > 0) {
                return this.createManualConstructorAssembler(cd);
            }
            if (cd.getExpression() != null) {
                return this.createExpressionConstructorAssembler(cd);
            }
            String autoBindingMode = cd.getAutoBindingMode();
            if (AutoBindingUtil.isAuto(autoBindingMode) || AutoBindingUtil.isConstructor(autoBindingMode)) {
                return this.createAutoConstructorAssembler(cd);
            }
            return this.createDefaultConstructorAssembler(cd);
        }

        public PropertyAssembler createPropertyAssembler(ComponentDef cd) {
            String autoBindingMode = cd.getAutoBindingMode();
            if (AutoBindingUtil.isAuto(autoBindingMode) || AutoBindingUtil.isProperty(autoBindingMode)) {
                return this.createAutoPropertyAssembler(cd);
            }
            if (cd.getPropertyDefSize() > 0) {
                return this.createManualPropertyAssembler(cd);
            }
            return this.createOtherPropertyAssembler(cd);
        }

        public MethodAssembler createInitMethodAssembler(ComponentDef cd) {
            return new DefaultInitMethodAssembler(cd);
        }

        public MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
            return new DefaultDestroyMethodAssembler(cd);
        }

        protected ConstructorAssembler createAutoConstructorAssembler(ComponentDef cd) {
            return new AutoConstructorAssembler(cd);
        }

        protected ConstructorAssembler createManualConstructorAssembler(ComponentDef cd) {
            return new ManualConstructorAssembler(cd);
        }

        protected ConstructorAssembler createExpressionConstructorAssembler(ComponentDef cd) {
            return new ExpressionConstructorAssembler(cd);
        }

        protected ConstructorAssembler createDefaultConstructorAssembler(ComponentDef cd) {
            return new DefaultConstructorAssembler(cd);
        }

        protected PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
            return new AutoPropertyAssembler(cd);
        }

        protected PropertyAssembler createManualPropertyAssembler(ComponentDef cd) {
            return new ManualPropertyAssembler(cd);
        }

        protected PropertyAssembler createOtherPropertyAssembler(ComponentDef cd) {
            return new DefaultPropertyAssembler(cd);
        }
    }
}

