package org.seasar.struts.taglib.html;

import javax.servlet.jsp.JspException;

import org.seasar.framework.util.IntegerConversionUtil;

/**
 * @author Satoshi Kimura
 */
public class SubmitTag extends org.apache.struts.taglib.html.SubmitTag {
    protected String indexId;
    
    /**
     * @return Returns the indexId.
     */
    public String getIndexId() {
        return indexId;
    }
    
    /**
     * @param indexId The indexName to set.
     */
    public void setIndexId(String indexId) {
        this.indexId = indexId;

        if (indexId != null) {
            super.indexed = true;
        }
    }

    protected void prepareIndex(StringBuffer handlers, String name) throws JspException {
        if (indexId == null) {
            super.prepareIndex(handlers, name);
            return;
        }
        Object value = super.pageContext.getAttribute(indexId);
        handlers.append("[");
        handlers.append(IntegerConversionUtil.toPrimitiveInt(value));
        handlers.append("]");
    }
}