package org.seasar.jsf.util;

import javax.faces.component.UIComponent;

/**
 * @author higa
 *  
 */
public final class UIComponentUtil {

    private UIComponentUtil() {
    }

    public static UIComponent findParent(UIComponent component,
            Class parentClass) {

        for (UIComponent parent = component.getParent(); parent != null; parent = parent
                .getParent()) {
            if (parentClass.isInstance(parent)) {
                return parent;
            }
        }
        throw new IllegalArgumentException(parentClass.getName());
    }
}