package org.seasar.jsf.taglib;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import javax.faces.webapp.ValidatorTag;
import javax.servlet.jsp.JspException;

import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * @author higa
 *  
 */
public class S2ValidatorTag extends ValidatorTag {

	private String binding;
	
	public S2ValidatorTag() {
	}
	
	public String getBinding() {
		return binding;
	}
	
	public void setBinding(String binding) {
		if (binding != null && !UIComponentTag.isValueReference(binding)) {
			throw new IllegalArgumentException("binding");
		}
		this.binding = binding;
	}
	
	public void release(){
        super.release();
        binding = null;
    }

	protected Validator createValidator() throws JspException {
		if (binding == null) {
            throw new EmptyRuntimeException("binding");
		}
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        ValueBinding vb = app.createValueBinding(binding);
        return (Validator) vb.getValue(context);
	}
}