package org.seasar.jsf.processor;

import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.exception.TagProcessorNotFoundRuntimeException;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlProcessor extends ElementProcessor {

	public HtmlProcessor() {
	}
	
	public void setup(String namespaceURI, String localName, String qName,
			Attributes attributes, JsfConfig jsfConfig) {

		super.setup(namespaceURI, localName, qName, attributes, jsfConfig);
		ViewProcessor viewProcessor = (ViewProcessor) findAncestor(ViewProcessor.class);
		if (viewProcessor == null) {
			throw new TagProcessorNotFoundRuntimeException(ViewProcessor.class);
		}
		String extendsPath = getProperty(JsfConstants.EXTENDS_ATTR);
		if (!StringUtil.isEmpty(extendsPath)) {
			viewProcessor.setExtendsPath(extendsPath);
		}
		String initAction = getProperty(JsfConstants.ACTION_ATTR);
		if (!StringUtil.isEmpty(initAction)) {
			viewProcessor.setInitAction(initAction);
		}
	}
}