package org.seasar.struts.plugin;

import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author Satoshi Kimura
 */
public class AutoStrutsConfigRegisterPlugInTest extends S2TestCase {

    public AutoStrutsConfigRegisterPlugInTest(String name) {
        super(name);
    }

    public void testInit() throws Exception {
        ModuleConfig moduleConfig = new TestModuleConfig();
        AutoStrutsConfigRegisterPlugIn plugin = new AutoStrutsConfigRegisterPlugIn();
        plugin.setEnableJar(false);
        plugin.init(null, moduleConfig);

        FormBeanConfig[] formBeanConfigs = moduleConfig.findFormBeanConfigs();
        assertEquals(1, formBeanConfigs.length);
        assertEquals(false, formBeanConfigs[0].getDynamic());
        assertEquals("testFormName", formBeanConfigs[0].getName());
        assertEquals("org.seasar.struts.plugin.TestForm", formBeanConfigs[0].getType());

        ActionConfig[] actionConfigs = moduleConfig.findActionConfigs();
        assertEquals(1, actionConfigs.length);
        assertEquals("testattribute", actionConfigs[0].getAttribute());
        assertEquals(true, actionConfigs[0].getValidate());
        assertEquals(false, actionConfigs[0].getUnknown());
        assertEquals("testforward", actionConfigs[0].getForward());
        assertEquals("testinclude", actionConfigs[0].getInclude());
        assertEquals("testinput", actionConfigs[0].getInput());
        assertEquals("testname", actionConfigs[0].getName());
        assertEquals("testparameter", actionConfigs[0].getParameter());
        assertEquals("testpath", actionConfigs[0].getPath());
        assertEquals("testprefix", actionConfigs[0].getPrefix());
        assertEquals("testroles", actionConfigs[0].getRoles());
        assertEquals("testsuffix", actionConfigs[0].getSuffix());
        assertEquals("org.seasar.struts.plugin.TestAction", actionConfigs[0].getType());
        assertEquals("request", actionConfigs[0].getScope());

        ForwardConfig[] forwardConfigs = actionConfigs[0].findForwardConfigs();
        assertEquals(2, forwardConfigs.length);
        assertEquals(false, forwardConfigs[0].getRedirect());
        assertEquals(true, forwardConfigs[0].getName().matches("success|fail"));
        assertEquals(true, forwardConfigs[0].getPath().matches("/test.jsp|/fail.jsp"));
        assertEquals(false, forwardConfigs[1].getRedirect());
        assertEquals(true, forwardConfigs[1].getName().matches("success|fail"));
        assertEquals(true, forwardConfigs[1].getPath().matches("/test.jsp|/fail.jsp"));

    }

    private static class TestModuleConfig extends ModuleConfigImpl {
        public TestModuleConfig() {
            super("");
            matcher = new ActionConfigMatcher(new ActionConfig[0]);
        }
    }

}
