/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.httpunit.mock;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class MockObjectInterceptor
extends AbstractInterceptor {
    private String methodName;
    private Object[] arguments;
    private Map values = new HashMap();
    private Map propertyValues = new HashMap();
    private Object target;

    public void setReturnValue(Object method, Object value) {
        this.values.put(method, value);
    }

    public Object getReturnValue(Object method) {
        return this.values.get(method);
    }

    public void setReturnValue(Object method, Object key, Object value) {
        HashMap<Object, Object> methodMap = (HashMap<Object, Object>)this.values.get(method);
        if (methodMap == null) {
            methodMap = new HashMap<Object, Object>();
            this.values.put(method, methodMap);
        }
        methodMap.put(key, value);
    }

    public Object getReturnValue(Object method, Object key) {
        Object methodValues = this.values.get(method);
        if (methodValues != null) {
            if (methodValues instanceof Map) {
                return ((Map)methodValues).get(key);
            }
            return methodValues;
        }
        return null;
    }

    public void setDelegateTarget(Object target) {
        this.target = target;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.init(invocation);
        this.setPropertyValue();
        Object retValue = this.getMockValue(invocation);
        if (retValue == null) {
            retValue = this.delegate(invocation);
        }
        if (retValue == null) {
            retValue = this.getPropertyValue(this.methodName);
        }
        return retValue;
    }

    public void setPropertyValue() {
        if (this.methodName.startsWith("set") && this.arguments.length == 1) {
            this.propertyValues.put(this.methodName.substring("set".length()), this.arguments[0]);
        }
    }

    public Object getPropertyValue(String methodName) {
        return this.getPropertyValue(methodName, false);
    }

    public Object getPropertyValue(String methodName, boolean force) {
        if (this.arguments == null && !force) {
            return null;
        }
        if (force || this.arguments.length == 0) {
            if (methodName.startsWith("get")) {
                return this.propertyValues.get(methodName.substring("get".length()));
            }
            if (methodName.startsWith("is")) {
                return this.propertyValues.get(methodName.substring("is".length()));
            }
            return null;
        }
        return null;
    }

    private void init(MethodInvocation invocation) {
        this.methodName = invocation.getMethod().getName();
        this.arguments = invocation.getArguments();
    }

    private Object getMockValue(MethodInvocation invocation) {
        Object retValue = null;
        if (this.arguments.length == 0) {
            retValue = this.getReturnValue(this.methodName);
        } else if (this.arguments.length == 1) {
            retValue = this.getReturnValue(this.methodName, this.arguments[0]);
        }
        return retValue;
    }

    private Object delegate(MethodInvocation invocation) {
        if (this.target == null) {
            return null;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.target.getClass());
        if (beanDesc.hasMethod(this.methodName)) {
            return beanDesc.invoke(this.target, this.methodName, this.arguments);
        }
        return null;
    }
}

