/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;
import org.hsqldb.util.TransferTable;

class PostgresTransferHelper
extends TransferHelper {
    private final int PostgreSQL = 0;
    private final int HSQLDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    PostgresTransferHelper() {
    }

    PostgresTransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        super(transferDb, traceable, string);
    }

    int convertToType(int n) {
        if (n == 3) {
            n = 2;
            this.tracer.trace("Converted DECIMAL to NUMERIC");
        }
        return n;
    }

    String fixupColumnDefRead(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        String string2 = new String("_" + resultSet.getString(4) + "_seq");
        int n2 = 31 - string2.length();
        string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
        String string3 = "nextval('\"" + string2 + "\"'";
        if (string.indexOf(string3) >= 0) {
            string = "SERIAL";
        }
        for (int i = 0; i < this.Funcs.length; ++i) {
            String string4 = this.Funcs[i][0];
            int n3 = string.indexOf(string4);
            if (n3 < 0) continue;
            String string5 = string.substring(0, n3);
            string5 = string5 + this.Funcs[i][1];
            string = string5 = string5 + string.substring(n3 + string4.length());
        }
        return string;
    }

    String fixupColumnDefWrite(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        if (string.equals("SERIAL")) {
            String string2 = new String("_" + resultSet.getString(4) + "_seq");
            int n2 = 31 - string2.length();
            string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
            String string3 = "DROP SEQUENCE " + string2 + ";";
            transferTable.Stmts.sDestDrop = transferTable.Stmts.sDestDrop + string3;
        }
        for (int i = 0; i < this.Funcs.length; ++i) {
            String string4 = this.Funcs[i][1];
            int n3 = string.indexOf(string4);
            if (n3 < 0) continue;
            String string5 = string.substring(0, n3);
            string5 = string5 + this.Funcs[i][0];
            string = string5 = string5 + string.substring(n3 + string4.length());
        }
        return string;
    }

    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void endDataTransfer() {
        try {
            this.db.commit();
            this.db.execute("VACUUM ANALYZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

