/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public final class PropertyDescImpl
implements PropertyDesc {
    private String propertyName_;
    private Class propertyType_;
    private Method readMethod_;
    private Method writeMethod_;
    private BeanDesc beanDesc_;
    private Constructor stringConstructor_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;

    public PropertyDescImpl(String propertyName, Class propertyType, Method readMethod, Method writeMethod, BeanDesc beanDesc) {
        if (propertyName == null) {
            throw new EmptyRuntimeException("propertyName");
        }
        if (propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        this.propertyName_ = propertyName;
        this.propertyType_ = propertyType;
        this.readMethod_ = readMethod;
        this.writeMethod_ = writeMethod;
        this.beanDesc_ = beanDesc;
        this.setupStringConstructor();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this.propertyType_.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(class$java$lang$String == null ? PropertyDescImpl.class$("java.lang.String") : class$java$lang$String)) continue;
            this.stringConstructor_ = con;
            break;
        }
    }

    public final String getPropertyName() {
        return this.propertyName_;
    }

    public final Class getPropertyType() {
        return this.propertyType_;
    }

    public final Method getReadMethod() {
        return this.readMethod_;
    }

    public final void setReadMethod(Method readMethod) {
        this.readMethod_ = readMethod;
    }

    public final boolean hasReadMethod() {
        return this.readMethod_ != null;
    }

    public final Method getWriteMethod() {
        return this.writeMethod_;
    }

    public final void setWriteMethod(Method writeMethod) {
        this.writeMethod_ = writeMethod;
    }

    public final boolean hasWriteMethod() {
        return this.writeMethod_ != null;
    }

    public final Object getValue(Object target) {
        return MethodUtil.invoke(this.readMethod_, target, null);
    }

    public final void setValue(Object target, Object value) {
        try {
            MethodUtil.invoke(this.writeMethod_, target, new Object[]{this.convertIfNeed(value)});
        }
        catch (Throwable t) {
            throw new IllegalPropertyRuntimeException(this.beanDesc_.getBeanClass(), this.propertyName_, t);
        }
    }

    public final BeanDesc getBeanDesc() {
        return this.beanDesc_;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this.propertyName_);
        buf.append(",propertyType=");
        buf.append(this.propertyType_.getName());
        buf.append(",readMethod=");
        buf.append(this.readMethod_ != null ? this.readMethod_.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this.writeMethod_ != null ? this.writeMethod_.getName() : "null");
        return buf.toString();
    }

    public Object convertIfNeed(Object arg) {
        if (this.propertyType_.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = PropertyDescImpl.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.propertyType_)) {
            return this.convertNumber(arg);
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = PropertyDescImpl.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(this.propertyType_)) {
            return this.convertDate(arg);
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyDescImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(this.propertyType_)) {
            return BooleanConversionUtil.toBoolean(arg);
        }
        if (arg instanceof String && !(class$java$lang$String == null ? (class$java$lang$String = PropertyDescImpl.class$("java.lang.String")) : class$java$lang$String).equals(this.propertyType_)) {
            return this.convertWithStringConstructor(arg);
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return NumberConversionUtil.convertPrimitiveWrapper(this.propertyType_, arg);
    }

    private Object convertNumber(Object arg) {
        return NumberConversionUtil.convertNumber(this.propertyType_, arg);
    }

    private Object convertDate(Object arg) {
        if (this.propertyType_ == (class$java$util$Date == null ? (class$java$util$Date = PropertyDescImpl.class$("java.util.Date")) : class$java$util$Date)) {
            return DateConversionUtil.toDate(arg);
        }
        if (this.propertyType_ == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PropertyDescImpl.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return TimestampConversionUtil.toTimestamp(arg);
        }
        if (this.propertyType_ == (class$java$sql$Date == null ? (class$java$sql$Date = PropertyDescImpl.class$("java.sql.Date")) : class$java$sql$Date)) {
            return SqlDateConversionUtil.toDate(arg);
        }
        if (this.propertyType_ == (class$java$sql$Time == null ? (class$java$sql$Time = PropertyDescImpl.class$("java.sql.Time")) : class$java$sql$Time)) {
            return TimeConversionUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithStringConstructor(Object arg) {
        if (this.stringConstructor_ == null || arg == null) {
            return arg;
        }
        return ConstructorUtil.newInstance(this.stringConstructor_, new Object[]{arg});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

