/*
 * Created on 2005/04/06
 */
package org.seasar.tapestry.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import sun.misc.SoftCache;

/**
 * @author maruo_syunsuke
 */
public class CopyUtil {
    private static final Log LOG = LogFactory.getLog(CopyUtil.class);
    
    private static SetterCache setterCache = new SetterCache();
    private static GetterCache getterCache = new GetterCache();
	
	public static void copy(Object dest, Object src, Object key) {
		if( dest == null || src == null || key == null ) return ;
        Map destSetterMethodList = setterCache.getSetterMap(dest.getClass());
        Map srcGetterMethodList = getterCache.getGetterMap(src.getClass());
        
    	invokeGetterToSetter(dest, src, key, destSetterMethodList, srcGetterMethodList);
    }
	public static void copyAll(Object dest, Object src) {
		if( dest == null || src == null ) return ;
        Map destSetterMethodList = setterCache.getSetterMap(dest.getClass());
        Map srcGetterMethodList = getterCache.getGetterMap(src.getClass());
        
        Iterator iterator = destSetterMethodList.keySet().iterator();
        while( iterator.hasNext()){
        	Object key = iterator.next();
        	invokeGetterToSetter(dest, src, key, destSetterMethodList, srcGetterMethodList);
        }
    }
	public static void set(Object dest, Object key, Object value) {
		if( dest == null || key == null ) return ;
        Map destSetterMethodList = setterCache.getSetterMap(dest.getClass());
        
        invokeToSetter(dest, key, value, destSetterMethodList );
    }
	public static void copyAllByPropertyName(Object dest, Object src) {
		copyAllByKey( dest, src, String.class );
    }
	public static void copyAllByClass(Object dest, Object src) {
		copyAllByKey( dest, src, Class.class );
	}
	private static void copyAllByKey(Object dest, Object src, Class keyClass){
		if( dest == null || src == null ) return ;
        Map destSetterMethodList = setterCache.getSetterMap(dest.getClass());
        Map srcGetterMethodList = getterCache.getGetterMap(src.getClass());
        
        Iterator iterator = destSetterMethodList.keySet().iterator();
        while( iterator.hasNext()){
        	Object key = iterator.next();
        	if( key.getClass().equals(keyClass) == false ) continue ;
        	invokeGetterToSetter(dest, src, key, destSetterMethodList, srcGetterMethodList);
        }
	}
	private static void invokeToSetter(Object dest, Object key, Object value, Map destSetterMethodList ) {
		if( destSetterMethodList.containsKey(key) == false) return ;
		Method setter = (Method)destSetterMethodList.get(key);
    	invoke(dest,setter,value);
	}
	private static void invoke(Object dest, Method setter, Object value) {
		try {
			setter.invoke(dest,	new Object[] {value});
			if( LOG.isInfoEnabled()){
				LOG.info( "CopyUtil Invoke : TO " + setter.getName() + "[" + value + "]");
			}
		} catch (IllegalArgumentException e) {
			LOG.info( "CopyUtil Invoke Error : TO " + setter.getName() + " Message " + e.getMessage() );
		} catch (IllegalAccessException e) {
			LOG.info( "CopyUtil Invoke Error : TO " + setter.getName() + " Message " + e.getMessage() );
		} catch (InvocationTargetException e) {
			LOG.info( "CopyUtil Invoke Error : TO " + setter.getName() + " Message " + e.getMessage() );
		}
	}
	private static void invokeGetterToSetter(Object dest, Object src, Object key, Map destSetterMethodList, Map srcGetterMethodList) {
		if( destSetterMethodList.containsKey(key) == false) return ;
    	if( srcGetterMethodList.containsKey(key) == false) return ;
    	Method getter = (Method)srcGetterMethodList.get(key);
    	Method setter = (Method)destSetterMethodList.get(key);
    	invoke(dest,src,setter,getter);
	}
    private static void invoke(Object dest, Object src, Method setter, Method getter ){
    	if( getter == null || setter == null ) return ;
    	try {
    		Object getObject = getter.invoke(src,new Object[0]) ;
			setter.invoke(dest,	new Object[] {getObject});
			if( LOG.isInfoEnabled()){
				LOG.info( "CopyUtil Invoke : " + getter.getName() + 
						" TO " + setter.getName() + "[" + getObject + "]");
			}
		} catch (Exception e) {
			LOG.info( "CopyUtil Invoke Error : " + getter.getName() + 
					" TO " + setter.getName() + " Message " + e.getMessage() );
		}
    }
    static class GetterCache{
		private Map srcMethodCache = new SoftCache();
	
		public synchronized Map getGetterMap(Class srcClass) {
			if( srcMethodCache.containsKey(srcClass)){
				return (Map)srcMethodCache.get(srcClass);
			}
			Map getterMap = makeGetterMap(srcClass);
	        cacheGetterMap(srcClass,getterMap);
			return getterMap;
		}
		private void cacheGetterMap(Class clazz, Map item){
	        srcMethodCache.put(clazz,item);
		}
		private Map makeGetterMap(Class srcClass) {
			Method[] srcMethods = srcClass.getMethods();
	        Map getterMap = new HashMap();
	        for (int i = 0; i < srcMethods.length; i++) {
	            Method srcMethod = srcMethods[i];
				if( AccessaUtil.isGetterMethod(srcMethod) == false ) continue ;
	            Class returnType = AccessaUtil.primitiveToWrapper(srcMethod.getReturnType());
	            getterMap.put( returnType,srcMethod );
	            getterMap.put( AccessaUtil.getPropertyName(srcMethod),srcMethod );
	        }
			return getterMap;
		}
	}
	static class SetterCache{
		private Map destMethodCache = new SoftCache();
		
		public synchronized Map getSetterMap(Class destClass) {
			if( destMethodCache.containsKey(destClass)){
				return (Map)destMethodCache.get(destClass);
			}
			Map setterMap = makeSetterMap(destClass);
	        cacheSetterMap(destClass,setterMap);
			return setterMap;
		}
		private Map makeSetterMap(Class destClass) {
			Method[] destMethods = destClass.getMethods();
	        Map setterMap = new HashMap();
	        for (int i = 0; i < destMethods.length; i++) {
	            Method destMethod = destMethods[i];
				if( AccessaUtil.isSetterMethod(destMethod ) == false ) continue ;
				
	            Class argType = AccessaUtil.primitiveToWrapper(
	            		destMethod.getParameterTypes()[0]);
	            if( argType == null ) continue ;
	            
	            setterMap.put(argType,destMethod);
	            setterMap.put(AccessaUtil.getPropertyName(destMethod),destMethod );
	        }
			return setterMap;
		}
		private void cacheSetterMap(Class clazz, Map item){
	        destMethodCache.put(clazz,item);
		}
	}
}
