/*
 * Created on 2005/04/11
 */
package org.seasar.tapestry.util;

import org.seasar.framework.container.S2Container;
import org.seasar.tapestry.S2TapestryServlet;

/**
 * @author maruo_syunsuke
 */
public class ContainerUtil {
	public static boolean hasObject(Class clazz){
		S2Container container = S2TapestryServlet.getContainer() ;
		return container.hasComponentDef(clazz);
	}
	public static Object getFromContainer(Class clazz){
		S2Container container = S2TapestryServlet.getContainer() ;
		return container.getComponent(clazz);
	}
	public static Object createFromContainer(Class clazz){
		S2Container container = S2TapestryServlet.getContainer() ;
		if( isPrototypeCreateFromSeasar(clazz) ){
			return container.getComponent(clazz);
		}
		throw new IllegalArgumentException();
	}
	private static boolean isPrototypeCreateFromSeasar(Class clazz){
		return checkMode(clazz, "prototype");
	}
	private static boolean checkMode(Class clazz, String mode){
		S2Container container = S2TapestryServlet.getContainer();
		return container.getComponentDef(clazz).getInstanceMode().equals(mode);
	}
	public static Object getFromContainer(Class clazz, String name){
		S2Container container = S2TapestryServlet.getContainer() ;
		Object obj = container.getComponent(name);
		if( obj == null ){
			throw new IllegalArgumentException("Container is not containts.");
		}
		if( clazz.isAssignableFrom(obj.getClass()) == false ){
			throw new IllegalArgumentException("Can't class cast.");
		}
		return obj ;
	}
}
