/*
 * 쐬F 2004/08/20
 */
package org.seasar.tapestry.engine;

import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.pageload.PageLoader;
import org.apache.tapestry.pageload.PageSource;
import org.apache.tapestry.resolver.PageSpecificationResolver;
import org.seasar.tapestry.util.InjectionUtil;

/**
 * @author maruo_syunsuke
 */
public class S2PageSource extends PageSource {
    
    public S2PageSource(IEngine engine) {
        super(engine);
    }

    protected S2PageLoader createPageLoader(IRequestCycle cycle) {
        S2PageLoader loader = new S2PageLoader(cycle);
        return loader;
    }

    protected PageLoader getPageLoader(IRequestCycle cycle) {
        throw new UnsupportedOperationException();
    }
    protected S2PageLoader getS2PageLoader(IRequestCycle cycle) {
        S2PageLoader result = (S2PageLoader) cycle.getEngine().getPool()
                .retrieve(PageLoader.class.getName());
        if (result == null)
            result = createPageLoader(cycle);
        InjectionUtil.invokeSetterInjection(result);
        return result;
    }
    
    public IPage getPage(IRequestCycle cycle, String pageName, IMonitor monitor) {
        IEngine engine = cycle.getEngine();
        Object key = buildKey(engine, pageName);
        IPage result = (IPage)cycle.getEngine().getPool().retrieve(key);
        if (result == null) {
            monitor.pageCreateBegin(pageName);

            // Resolvers are not threadsafe, so we get one from
            // the pool or create as needed.

            PageSpecificationResolver pageSpecificationResolver = getPageSpecificationResolver(cycle);

            pageSpecificationResolver.resolve(cycle, pageName);

            // Likewise PageLoader

            //            PageLoader loader = getPageLoader(cycle);
            S2PageLoader loader = getS2PageLoader(cycle);

            try {
                result = loader.loadPage(pageSpecificationResolver
                        .getSimplePageName(), pageSpecificationResolver
                        .getNamespace(), cycle, pageSpecificationResolver
                        .getSpecification());
            } finally {
                //                discardPageLoader(loader);
                cycle.getEngine().getPool().store(this.getClass().getName(),
                        loader);
                discardPageSpecificationResolver(pageSpecificationResolver);
            }

            monitor.pageCreateEnd(pageName);
        } else {
            // The page loader attaches the engine, but a page from
            // the pool needs to be explicitly attached.
            result.attach(engine);
            result.setRequestCycle(cycle);
        }

        return result;
    }
}